
data_base_dir="../data/"


base_dir=paste0(data_base_dir,"/ParTIES/")

retention = read.table(paste0(data_base_dir,"internal_eliminated_sequence_PGM_IES51.wt_retention_status.tab"),h=T)
cols=c("SUPPORT","RETENTION_SCORE_LEFT","RETENTION_SCORE_RIGHT","RETENTION_SCORE","PADJ_LEFT","SIGNIFICANT_LEFT","PADJ_RIGHT","SIGNIFICANT_RIGHT","SIGNIFICANT")




retention = merge(retention,get_MIRET_score(paste(sep="",base_dir,"ABK_COSP/ParTIES/MIRET/MIRET.tab"),all=T),by="ID")
colnames(retention)[(length(colnames(retention))- length(cols) + 1):length(colnames(retention))]=paste(cols,"_PGM_r1",sep="")

retention = merge(retention,get_MIRET_score(paste(sep="",base_dir,"PGM-1_FACS_ANLG///ParTIES/MIRET/MIRET.tab"),all=T),by="ID")
colnames(retention)[(length(colnames(retention))- length(cols) + 1):length(colnames(retention))]=paste(cols,"_PGM_r2",sep="")

retention$SIGNIFICANT_PGM =retention$SIGNIFICANT_PGM_r1 | retention$SIGNIFICANT_PGM_r2
retention$RETENTION_SCORE_PGM =apply(retention[,paste0("RETENTION_SCORE_",c("PGM_r1","PGM_r2"))],1,mean)



retention = merge(retention,get_MIRET_score(paste(sep="",base_dir,"Ezl174-1_RNAi_r1_r2//ParTIES/MIRET/MIRET.tab"),all=T),by="ID")
colnames(retention)[(length(colnames(retention))- length(cols) + 1):length(colnames(retention))]=paste(cols,"_EZL1_r1",sep="")

retention = merge(retention,get_MIRET_score(paste(sep="",base_dir,"Ezl174-2_RNAi_r1///ParTIES/MIRET/MIRET.tab"),all=T),by="ID")
colnames(retention)[(length(colnames(retention))- length(cols) + 1):length(colnames(retention))]=paste(cols,"_EZL1_r2",sep="")

retention$SIGNIFICANT_EZL1 =retention$SIGNIFICANT_EZL1_r1 | retention$SIGNIFICANT_EZL1_r2
retention$RETENTION_SCORE_EZL1 =apply(retention[,paste0("RETENTION_SCORE_",c("EZL1_r1","EZL1_r2"))],1,mean)


retention = merge(retention,get_MIRET_score(paste(sep="",base_dir,"TFIIS4/ParTIES/MIRET/MIRET.tab"),all=T),by="ID")
colnames(retention)[(length(colnames(retention))- length(cols) + 1):length(colnames(retention))]=paste(cols,"_TFIIS4",sep="")

retention = merge(retention,get_MIRET_score(paste(sep="",base_dir,"DCL2_3_RNAi_r1_HBJ-1/ParTIES/MIRET/MIRET.tab"),all=T),by="ID")
colnames(retention)[(length(colnames(retention))- length(cols) + 1):length(colnames(retention))]=paste(cols,"_DCL23_r1",sep="")

retention = merge(retention,get_MIRET_score(paste(sep="",base_dir,"Dcl2-3_RNAi_r2/ParTIES/MIRET/MIRET.tab"),all=T),by="ID")
colnames(retention)[(length(colnames(retention))- length(cols) + 1):length(colnames(retention))]=paste(cols,"_DCL23_r2",sep="")

retention$SIGNIFICANT_DCL23 =retention$SIGNIFICANT_DCL23_r1 | retention$SIGNIFICANT_DCL23_r2
retention$RETENTION_SCORE_DCL23 =apply(retention[,paste0("RETENTION_SCORE_",c("DCL23_r1","DCL23_r2"))],1,mean)

retention = merge(retention,get_MIRET_score(paste(sep="",base_dir,"DCL5_RNAi_r1_HBJ-2//ParTIES/MIRET/MIRET.tab"),all=T),by="ID")
colnames(retention)[(length(colnames(retention))- length(cols) + 1):length(colnames(retention))]=paste(cols,"_DCL5",sep="")


retention$SIGNIFICANT_ONLY_EXC_CPLX = rowSums(retention[,paste0("SIGNIFICANT_",c("EZL1","TFIIS4","DCL23","DCL5"))])==0


rownames(retention)=retention$ID
