
source("../headers.R")

#exp7
options(stringsAsFactors = FALSE)

cfg=list(
"JA2"=list(EXP_CATEGORY="INJECTED",PREFIXES=c(
"PTET_FRAG_T3_JA2_Inj_REGN27",
#~ "PTET_FRAG_T10_JA2_Inj_REGN30",
#~ "PTET_FRAG_T30_JA2_Inj_REGN33",
"PTET_Nuc_32N_T3_JA2_Inj_REGN26",
"PTET_Nuc_33N_T10_JA2_Inj_REGN28",
"PTET_Nuc_57N_T10_JA2_Inj_REGN29",
"PTET_Nuc_64N_T30_JA2_Inj_REGN31",
"PTET_Nuc_115N_T30_JA2_Inj_REGN32"
),
NUCLEUS=c(rep("FRAG",1),rep("NUC",5)),
TIME=c("T3",
#~ "T10","T30",
"T3","T10","T10","T30","T30"),
SEQ_DATE=c(rep("Jul2020",6)),
PLOIDY=c(rep("800",1),"32","33","57","64","115"),
ROUND=c(rep(NA,1),4,4,5,5,6),
CLEVEL=c(rep(NA,1),"32C","32C","64C","64C","128C"),
DEV=c(rep(NA,1),1,2,2,3,3)
)
)


alg_prefixes=c()
frag_prefixes=c()

alg_labels=c()
frag_labels=c()

for(tc in names(cfg)) {
    prefixes=cfg[[tc]][["PREFIXES"]]
    rounds=cfg[[tc]][["ROUND"]]
    devs=cfg[[tc]][["DEV"]]
    nucleus=cfg[[tc]][["NUCLEUS"]]
    clevels=cfg[[tc]][["CLEVEL"]]
    labels=c()
    for(p in 1:length(prefixes)) {
        lab=NA
        if(nucleus[p]=="NUC") {
            lab=paste0(clevels[p],"-DEV",devs[p]," (",tolower(tc),")")
            alg_prefixes=c(alg_prefixes,prefixes[p])
            alg_labels=c(alg_labels,lab)
        } else {
            lab=paste0("FRAG (",tolower(tc),")")
            frag_prefixes=c(frag_prefixes,prefixes[p])
            frag_labels=c(frag_labels,lab)
        }
        
        labels=c(labels,lab)
    }
     cfg[[tc]][["LABELS"]]=labels
    
}




source("../functions.R")


data_base_dir="../data/"


base_dir=paste0(data_base_dir,"/ParTIES/")



base_img_dir=paste0("images/")
base_result_dir=paste0("results/")

dir.create(base_img_dir,showWarnings=F,  recursive=T)
dir.create(base_result_dir,showWarnings=F,  recursive=T)



img_dir=paste0(base_img_dir,"JA2/")
dir.create(img_dir,showWarnings=F,  recursive=T)


##########################################################""
# NORMAL
##########################################################



scores = read.table(paste0(data_base_dir,"internal_eliminated_sequence_PGM_IES51.wt_retention_status.tab"),h=T)


cols=c("SUPPORT","RETENTION_SCORE_LEFT","RETENTION_SCORE_RIGHT","RETENTION_SCORE")
for(p in 1:length(frag_prefixes)) {
    scores = merge(scores,get_MIRET_score(paste(sep="",base_dir,"/",frag_prefixes[p],"/ParTIES/MIRET/MIRET.tab"),significant=FALSE,all=T),by="ID")
    colnames(scores)[(length(colnames(scores))- length(cols) + 1):length(colnames(scores))]=paste(cols,"_",frag_labels[p],sep="")
}


cols=c("SUPPORT","RETENTION_SCORE_LEFT","RETENTION_SCORE_RIGHT","RETENTION_SCORE","PADJ_LEFT","SIGNIFICANT_LEFT","PADJ_RIGHT","SIGNIFICANT_RIGHT","SIGNIFICANT")
for(p in 1:length(alg_prefixes)) {
    scores = merge(scores,get_MIRET_score(paste(sep="",base_dir,"/",alg_prefixes[p],"/ParTIES/MIRET/MIRET.tab"),all=T,mac_normalization_factor=NA),by="ID")
    colnames(scores)[(length(colnames(scores))- length(cols) + 1):length(colnames(scores))]=paste(cols,"_",alg_labels[p],sep="")
}


#vcolors=c(rep(rev(brewer.pal(9,"Reds"))


vcolors=rep("darkgrey",length(labels))
med_color="#E41A1C"
med_color="black"
        
df = 1-scores[,paste0("RETENTION_SCORE_",labels)]
colnames(df)=labels
df$ID=rownames(df)
df.m <- reshape2::melt(df, id.vars = "ID", na.rm = TRUE)
gp_irs<-ggplot(df.m, aes(x = variable, y = value, fill=variable)) +
   coord_cartesian(ylim=c(0,1)) +
    scale_color_manual(values = c("white") ) +
   scale_fill_manual(values = rep("darkgrey",ncol(df)-1)) +
    geom_violin(trim=TRUE,scale="width",  color="white") +
                  stat_summary(fun.data=data_summary, 
                  geom="pointrange", color=med_color,lwd=0.9) +
   labs(title="",x="", y = "IES Excision Score",size=13,color = "black") +  
   theme(text=element_text(size=13,color = "black"),legend.position="none",panel.background = element_blank(),
      axis.line = element_line(color = "black"),
      axis.text.y = element_text(size=13,color = "black"),
      axis.text.x = element_text(angle = 45, hjust = 1,size=13,color = "black")
      )
gp_irs     
  
ggsave(paste0(img_dir,"violin_plot_IES_Excision_Score.pdf"), plot = gp_irs)    
        


##########################################################""
# RMDUP
##########################################################


scores = read.table(paste0(data_base_dir,"internal_eliminated_sequence_PGM_IES51.wt_retention_status.tab"),h=T)


cols=c("SUPPORT","RETENTION_SCORE_LEFT","RETENTION_SCORE_RIGHT","RETENTION_SCORE")
for(p in 1:length(frag_prefixes)) {
    scores = merge(scores,get_MIRET_score(paste(sep="",base_dir,"/rmdup/",frag_prefixes[p],".rmdup/ParTIES/MIRET/MIRET.tab"),significant=FALSE,all=T),by="ID")
    colnames(scores)[(length(colnames(scores))- length(cols) + 1):length(colnames(scores))]=paste(cols,"_",frag_labels[p],sep="")
}


cols=c("SUPPORT","RETENTION_SCORE_LEFT","RETENTION_SCORE_RIGHT","RETENTION_SCORE","PADJ_LEFT","SIGNIFICANT_LEFT","PADJ_RIGHT","SIGNIFICANT_RIGHT","SIGNIFICANT")
for(p in 1:length(alg_prefixes)) {
    scores = merge(scores,get_MIRET_score(paste(sep="",base_dir,"/rmdup/",alg_prefixes[p],".rmdup/ParTIES/MIRET/MIRET.tab"),all=T,mac_normalization_factor=NA),by="ID")
    colnames(scores)[(length(colnames(scores))- length(cols) + 1):length(colnames(scores))]=paste(cols,"_",alg_labels[p],sep="")
}



#vcolors=c(rep(rev(brewer.pal(9,"Reds"))


vcolors=rep("darkgrey",length(labels))
med_color="#E41A1C"
med_color="black"
        
df = 1-scores[,paste0("RETENTION_SCORE_",labels)]
colnames(df)=labels
df$ID=rownames(df)
df.m <- reshape2::melt(df, id.vars = "ID", na.rm = TRUE)
gp_irs<-ggplot(df.m, aes(x = variable, y = value, fill=variable)) +
   coord_cartesian(ylim=c(0,1)) +
    scale_color_manual(values = c("white") ) +
   scale_fill_manual(values = rep("darkgrey",ncol(df)-1)) +
    geom_violin(trim=TRUE,scale="width",  color="white") +
                  stat_summary(fun.data=data_summary, 
                  geom="pointrange", color=med_color,lwd=0.9) +
   labs(title="",x="", y = "IES Excision Score",size=13,color = "black") +  
   theme(text=element_text(size=13,color = "black"),legend.position="none",panel.background = element_blank(),
      axis.line = element_line(color = "black"),
      axis.text.y = element_text(size=13,color = "black"),
      axis.text.x = element_text(angle = 45, hjust = 1,size=13,color = "black")
      )
gp_irs     

ggsave(paste0(img_dir,"violin_plot_IES_Excision_Score_rmdup.pdf"), plot = gp_irs)    
        
