'''
Finds all shared significant windows.
Usage: python3 find_common_sigWindows.py <input files> <output file>
'''

import sys

if len(sys.argv) < 4:
	sys.exit(__doc__)

list_files = sys.argv[1:-1]

sigWindows = []
di = {}
for i in range(len(list_files)):
	filename = list_files[i]
	sigWindows.append([])
	with open(filename, 'r') as f:
		header = f.readline()
		for line in f:
			fields = line.rstrip('\n').split('\t')
			window = fields[0]
			start = fields[1]
			stop = fields[2]
			sigWindows[i].append(window)
			di[window] = window + '\t' + start + '\t' + stop

shared_windows = []
for window in sigWindows[0]:
	shared_windows.append(window)
	for i in range(len(sigWindows)-1):
		if window not in sigWindows[i+1]:
			shared_windows.remove(window)
			break

with open(sys.argv[-1], 'w') as o:
	for window in shared_windows:
		o.write(di[window] + '\n')

