'''
Prints all possible kmers of a given length to standard output.
Usage: python3 print_all_kmers.py <kmer length>
'''

import sys

if len(sys.argv) != 2:
	sys.exit(__doc__)

try:
	kmer_length = int(sys.argv[1])
except TypeError:
	sys.exit(__doc__)

#Taken from generate_random_bcs.py script /bar/adu/LTR18A/cre-seq/remake_library_round2/putting_the_library_together/generate_random_bcs.py
#Edited to create bases directly instead of numbers for bases
def gen_all_bcs(bases_to_add): # Silas Hsu basically wrote this
        '''
        Input: integer > 0 for length of desired barcodes.
        Output: list of all possible barcodes of desired length.
        '''
        if bases_to_add == 1:
                return ['A', 'T', 'C', 'G'] # bases A = 0, T = 1, C = 2, G = 3
        bcs = [] # list for storing all generated barcodes
        bcs_one_less_base = gen_all_bcs(bases_to_add - 1) # calls function until bases_to_add == 1
        for bc in bcs_one_less_base: # add a base at every iteration
                bcs.append(bc + 'A') # add A
                bcs.append(bc + 'T') # add T
                bcs.append(bc + 'C') # add C
                bcs.append(bc + 'G') # add G
        return bcs # returns list of barcodes

all_kmers = gen_all_bcs(kmer_length)
counter = 0
for kmer in all_kmers:
	name = '>kmer' + str(counter)
	print(name)
	print(kmer)
	counter += 1

