'''
Gets transition/transversion rates from called transitions/transversions file.
Usage: python3 get_transition_transversion_rates_all.py <input file> <output file>
'''

import sys

if len(sys.argv) != 3:
	sys.exit(__doc__)

num_transitions = 0
num_transversions = 0
total = 0
with open(sys.argv[1], 'r') as f:
	for line in f:
		if line.startswith('>'):
			name = line.strip()
			seq = f.readline().rstrip()
			for i in range(len(seq)):
				if seq[i] == '-' or seq[i] == 'D': #Skip if gap or degenerate base
					continue
				elif seq[i] == 'M': #Match
					total += 1
				elif seq[i] == '1': #Transition
					num_transitions += 1
					total += 1
				elif seq[i] == '2': #Transversion
					num_transversions += 1
					total += 1

with open(sys.argv[-1], 'w') as o:
	o.write('Type\tRate\tNumber\n')
	num_conserved = total - num_transitions - num_transversions
	rate_conserved = num_conserved/total
	o.write('Conserved\t' + str(rate_conserved) + '\t' + str(num_conserved) + '\n')
	rate_transitions = num_transitions/total
	o.write('Transitions\t' + str(rate_transitions) + '\t' + str(num_transitions) + '\n')
	rate_transversions = num_transversions/total
	o.write('Transversions\t' + str(rate_transversions) + '\t' + str(num_transversions) + '\n')

