'''
Gets forward and reverse orientation elements mean log2FC.
Usage: python3 get_forward_reverse_orientation.py <input file> <output file>
'''

import sys
import math

if len(sys.argv) != 3:
	sys.exit(__doc__)

rev_elements = []
di = {}
with open(sys.argv[1], 'r') as f:
	header = f.readline()
	for line in f:
		fields = line.rstrip('\n').split('\t')
		cre = fields[1]
		mean = str(math.log2(float(fields[2])))
		if 'reverse' in cre:
			rev_elements.append(';'.join(cre.split(';')[:-1]))
		di[cre] = mean

with open(sys.argv[2], 'w') as o:
	o.write('Element\tForward\tReverse\n')
	for element in rev_elements:
		new_fields = []
		new_fields.append(element)
		new_fields.append(di[element])
		new_fields.append(di[element + ';reverse'])
		o.write('\t'.join(new_fields) + '\n') 
