library(ggplot2)
library(ggpubr)
source('~/ggplotting_source', encoding = 'UTF-8')

#Load data
#Load DBP data for HepG2 and K562 as "both_dbp_mutagenesis_mutEffect_forR"
#Load JUN data for HepG2 and K562 as "both_jun_mutagenesis_mutEffect_forR"
colnames(both_dbp_mutagenesis_mutEffect_forR)[2] <- "mutation_effect"
colnames(both_dbp_mutagenesis_mutEffect_forR)[4] <- "cell_line"
colnames(both_jun_mutagenesis_mutEffect_forR)[2] <- "mutation_effect"
colnames(both_jun_mutagenesis_mutEffect_forR)[4] <- "cell_line"

#Plot
#DBP
dbp_plot <- ggplot(both_dbp_mutagenesis_mutEffect_forR, aes(x=mutation, y=mutation_effect)) + 
  geom_boxplot(aes(fill=cell_line)) +
  geom_jitter(width=0.2) +
  stat_compare_means(method = "wilcox.test", label.x.npc="center") +
  labs(title='DBP mutation effects on enhancer activity', 
       x="Mutation type", y="log2 fold change")
facet(dbp_plot, facet.by="cell_line")

#JUN
jun_plot <- ggplot(both_jun_mutagenesis_mutEffect_forR, aes(x=mutation, y=mutation_effect)) + 
  geom_boxplot(aes(fill=cell_line)) +
  geom_jitter(width=0.2) +
  stat_compare_means(method = "wilcox.test", label.x.npc="center") +
  labs(title='JUN mutation effects on enhancer activity', 
       x="Mutation type", y="log2 fold change")
facet(jun_plot, facet.by="cell_line")
