'''
Gets the basalNorm values for mutagenesis pairs before and after mutagenesis.
Usage: python3 get_mutagenesis_basalNorm.py <input basalNorm file> <mutagenesis motif location file> <motif name> <output file>
'''

import sys

if len(sys.argv) != 5:
	sys.exit(__doc__)

motif = sys.argv[3]

di = {}
with open(sys.argv[1], 'r') as f:
	header = f.readline()
	for line in f:
		fields = line.rstrip('\n').split('\t')
		cre = fields[1]
		di[cre] = fields[2]

with open(sys.argv[2], 'r') as f:
	with open(sys.argv[4], 'w') as o:
		o.write('CRE1\twMotif_basalNorm\tmutMotif_basalNorm\tCRE2\twoMotif_basalNorm\tmutMotif_basalNorm\n')
		for line in f:
			fields = line.rstrip('\n').split('\t')
			cre1 = fields[0]
			cre2 = fields[4]
			cre1_mut = cre1 + ';' + motif + 'mutant'
			cre2_mut = cre2 + ';' + motif + 'mutant'
			if cre1_mut not in di:
				continue
			elif cre2_mut not in di:
				continue
			new_fields = []
			if fields[5] == '.': #cre1 has a motif, cre2 doesn't have motif
				new_fields.append(cre1)
				new_fields.append(di[cre1])
				new_fields.append(di[cre1_mut])
				new_fields.append(cre2)
				new_fields.append(di[cre2])
				new_fields.append(di[cre2_mut])
			elif fields[1] == '.': #cre1 doesn't have motif, cre2 has a motif
				new_fields.append(cre2)
				new_fields.append(di[cre2])
				new_fields.append(di[cre2_mut])
				new_fields.append(cre1)
				new_fields.append(di[cre1])
				new_fields.append(di[cre1_mut])
			o.write('\t'.join(new_fields) + '\n')

