'''
Calculates the log2FC change in activity caused by mutagenesis.
Usage: python3 calc_mut_change.py <input file> <output file>
'''

import sys
import math

if len(sys.argv) != 3:
	sys.exit(__doc__)

order = []
di = {}
with open(sys.argv[1], 'r') as f:
	header = f.readline()
	for line in f:
		fields = line.rstrip('\n').split('\t')
		cre1 = fields[0]
		change1 = math.log2(float(fields[2])) - math.log2(float(fields[1]))
		cre2 = fields[3]
		change2 = math.log2(float(fields[5])) - math.log2(float(fields[4]))
		order.append(cre1)
		di[cre1] = [cre1, str(change1), cre2, str(change2)]

with open(sys.argv[2], 'w') as o:
	o.write('CRE1\tMotif_loss_effect\tCRE2\tMotif_gain_effect\n')
	for name in order:
		o.write('\t'.join(di[name]) + '\n')

