'''
Calculates the mean of effect sizes for each cell line/mutation type combination (e.g. HepG2 motif gain)
Usage: python3 calc_effectSize_mean.py <input file> <output file>
'''

import sys
import statistics as stats

if len(sys.argv) != 3:
	sys.exit(__doc__)

combinations = []
di = {}
with open(sys.argv[1], 'r') as f:
	header = f.readline()
	for line in f:
		fields = line.rstrip().split('\t')
		effect = float(fields[1])
		mutation_type = fields[2]
		cell_line = fields[3]
		combo = cell_line + ' ' + mutation_type
		if combo not in combinations:
			combinations.append(combo)
			di[combo] = []
		di[combo].append(effect)

with open(sys.argv[-1], 'w') as o:
	o.write('Mutagenesis type\tMean effect size\n')
	for combo in combinations:
		o.write(combo + '\t' + str(stats.mean(di[combo])) + '\n')

