#! /bin/bash

trap 'exit' INT

module load plink

# scriptsDir  :  the location of this script
scriptsDir="$(dirname $(readlink -f $0))"

# All three of these variables must be set properly for the scripts to work successfully.
# fullFasta  :  sequence data (NOT aligned)
fullFasta=$1
# phenFile  :  phenotype data
phenFile=$2
# alnFasta  :  aligned sequence data (must be aligned)
alnFasta=$3

if [[ ! -e $phenFile ]]
then
    phenFile='~/TWAS/njensen_script_for_plink/try_ltr18a_again/LTR18A_epigenetic_annotations.txt'
fi
if [[ ! -e $fullFasta ]]
then
    fullFasta='~/TWAS/njensen_script_for_plink/try_ltr18a_again/hg19_ltr18a_seq_ordered.fa'
fi    

if [[ ! -e $phenFile || ! -e $fullFasta ]]
then
    echo 'Fatal error: You must set both variables (in this script) "fullFasta" and "phenFile" to the absolute location of the actual files.'
    exit 1
fi


# NOTE: if you didn't set $alnFasta properly, then the script tries to use mafft to align the sequences for your convenience.
# For this to work, mafft must be installed. Mafft is not required for any other process.
#if [[ ! -e $alnFasta ]]
#then
#    alnFasta='~/TWAS/njensen_script_for_plink/try_ltr18a_again/mafft_hg19_ltr18a.fa'
#fi
#if [[ ! -e $alnFasta ]]
#then
#    alnFasta='TMP.aln.fa'
#    mafft $fullFasta > $alnFasta
#fi
#if [[ ! -e $alnFasta ]]
#then
#    echo 'Fatal Error: Oops! It looks like you did not set "alnFasta" variable correctly, and you do not have mafft. Sorry!'
#    exit 1
#fi

echo "Running with fasta file $fullFasta"
echo "Running with aln file $alnFasta"
echo "Running with phen file $phenFile"

# Get phenotype names
read -r -a phenArr <<< $( head -n 1 $phenFile )
phenArr=("${phenArr[@]:1}")


# NOTE: If you don't want to run plink, comment out these four lines.
mkdir aln_result
cd aln_result
bash $scriptsDir/aln_methods/runAlnMethods.sh $phenFile $fullFasta $alnFasta $scriptsDir "${phenArr[@]}"
cd ..

# NOTE: If you don't want to run the kmer-based (non-plink) methods, comment out these four lines.
mkdir kmer_result
cd kmer_result
bash $scriptsDir/kmer_methods/runKmerMethods.sh $phenFile $fullFasta $scriptsDir
cd ..

# NOTE: If you don't want to summarize the results, comment this out.
echo 'Writing positives summary to positivesSummary.log'
bash $scriptsDir/helpers/summarizePositives.sh $scriptsDir > positivesSummary.log

