'''
Sets up input files for Needle-Wunsch alignment from fasta file.
Usage: python3 setup_needle_kmers.py <input .fa file> <output directory name>
'''

import sys, os

if len(sys.argv) != 3:
	sys.exit(__doc__)

dirname = sys.argv[2]
os.mkdir(dirname)
with open(sys.argv[1], 'r') as f:
	count = 1
	for line in f:
		if ">" in line:
			name = line.rstrip('\n')
			seq = f.readline().rstrip('\n')
			filename = dirname + "/input" + str(count)
			with open(filename, 'w') as o:
				o.write(name + '\n' + seq + '\n')
			count += 1

