#! /bin/bash

trap 'exit' INT

phenFile=$1
fullFasta=$2
scriptsDir=$3
kmerMethodsDir="$scriptsDir/kmer_methods"

kMIN=3
kMAX=20

echo "Counting kmers of length:"
for i in `seq ${kMIN} ${kMAX}`
do
    if [[ ! -e counts$i.txt.gz && ! -e counts$i.txt ]]; then
        echo $i
        python3.5 "$kmerMethodsDir/countKmers.py" $i $phenFile $fullFasta -report c counts$i.txt
    fi
done

echo 'Getting p-values for kmers of length:'
for i in `seq ${kMIN} ${kMAX}`
do
    if [[ ! -e important$i.txt.gz && ! -e important$i.txt ]]; then
        echo $i
        Rscript "$kmerMethodsDir/analyzeKmerCounts.R" counts$i.txt > important$i.log
    fi
done

gzip counts*

#### The remaining portion of this script is non-essential. It will assemble kmers into a pretty picture that represents significance (ambiguously assembled.)

# echo 'Assembling contigs from kmers:'
# for i in `seq ${kMIN} ${kMAX}`
# do
#     if [[ -e important$i.txt && ! -e important$i.fastk ]]; then
#       echo $i
#       python3.5 "$kmerMethodsDir/kmerAssembler.py" important$i.txt
#     fi
# done
# 
# echo 'Creating html diagrams:'
# for i in `seq ${kMIN} ${kMAX}`
# do
#     if [[ ! -e important$i.html && -e important$i.fastk ]]; then
#       echo $i
#       python3.5 "$kmerMethodsDir/generateHtml.py" important$i.fastk
#     fi
# done
# 
# # Used for k-mer method -- aligning contigs back to consensus sequence.
# # consensusFasta  :  contains consensus sequences for each phenotype case and control groups, as well as the overall consensus of all sequences.
# # Note: consensus.py generates most of that. You may need to append the consensus of all sequences onto the end (with id line ">consensus") but that's not hard to do.
# consensusFasta="consensus.fa"
# if [[ ! -e $consensusFasta ]]
# then
#     echo 'Creating consensus sequences'
#     python3.5 "$kmerMethodsDir/consensus.py" $fullFasta $phenFile
# fi
# 
# echo 'Matching assembly to consensus:'
# for i in `seq ${kMIN} ${kMAX}`
# do
#     if [[ -e important$i.fastk ]]
#     then
#         echo $i
#         python3.5 "$kmerMethodsDir/matchAssemblyToConsensus.py" important$i.fastk $consensusFasta
#     fi
# done

echo 'Aligning significant kmers to each other.'
for i in `seq ${kMIN} ${kMAX}`
do
    if [[ -e important$i.txt ]]
    then
        echo $i
        python3.5 "$kmerMethodsDir/alignKmers.py" important$i.txt
    fi
done

gzip important*

echo 'Done.'
