#! /usr/bin/env python3.5

import os
import subprocess

def readKmers(fname) :
  ifh = open(fname, 'rt')
  header = ifh.readline().strip().split()
  i_phen = header.index('phen')
  i_kmer = header.index('kmer')
  i_P_chi = header.index('P_chi')
  i_log_P_chi = header.index('log_P_chi')
  kmersByPhen = {}
  for line in ifh :
    line = line.strip().split()
    if line[i_phen] not in kmersByPhen :
      kmersByPhen[line[i_phen]] = {}
    kmersByPhen[line[i_phen]][line[i_kmer]] = float(line[i_log_P_chi])
  ifh.close()
  return kmersByPhen

def writeKmers(fname, kmersByPhen) :
  dirname = 'alignedKmers'
  if not os.path.exists(dirname) :
    os.mkdir(dirname)
  for phen in kmersByPhen :
    tmp_ofname = os.path.join(dirname, 'tmp.fa')
    tmp_ofh = open(tmp_ofname, 'wt')
    aln_ofname = os.path.join(dirname, fname[:-4] + '.%s.aln.fa' %phen)
    i = 1
    for kmer in kmersByPhen[phen] :
      id = '%d|%s|%f' %(i, phen, kmersByPhen[phen][kmer])
      tmp_ofh.write('> %s\n%s\n' %(id, kmer))
      i += 1
    tmp_ofh.close()
    with open(os.devnull, 'wb') as devnull :
        with open(aln_ofname, 'wb') as aln :
          subprocess.run(['mafft', tmp_ofname], stderr=devnull, stdout=aln)
    os.remove(tmp_ofname)
  return

def main(fname) :
  kmersByPhen = readKmers(fname)
  writeKmers(fname, kmersByPhen)
  return

if __name__ == '__main__' :
  import argparse
  parser = argparse.ArgumentParser()
  parser.add_argument('fname', help='Filename of input, as output from analyzeKmerCounts.R usually named \"important#.txt\"')
  args = parser.parse_args()
  main(args.fname)

