#! /bin/bash

cwd=$(pwd)

scriptsDir=$1
testKmer="$scriptsDir/helpers/summarizePositiveKmers.py"

# returns "expandP majorP ratio"
function testPLimRatio() {
    expFile=$1
    majFile=$2
    pLim=$3
    expandP="$( awk "{ if (\$9 < $pLim) print }" $expFile | wc -l )"
    majorP="$( awk "{ if (\$9 < $pLim) print }" $majFile | wc -l )"
    if [ $majorP -eq "0" ]
    then
        ratio=0
    else
        ratio=$( bc -l <<< "scale=2; $expandP / $majorP" )
    fi
    echo "$expandP $majorP $ratio"
}

# returns counts for p-value < pLim in one file
function testPLim() {
    iFile=$1
    pLim=$2
    pVal="$( awk "{ if (\$9 < $pLim) print }" $iFile | wc -l )"
    echo "$pVal"
}


# [Phen]
#          5e-5   5e-10   5e-15   5e-20
# Expand
# Major
function testAln() {
  for expFile in epigen_expand_*.assoc
  do
    majFile="${expFile/expand/major}"
    p5=$(testPLim $expFile 5e-5)
    p10=$(testPLim $expFile 5e-10)
    p15=$(testPLim $expFile 5e-15)
    p20=$(testPLim $expFile 5e-20)
    stub="${expFile%.*}"
    echo "           ${stub/epigen_expand_/}"
    echo "        5e-5  5e-10  5e-15  5e-20"
    echo "Expand  $p5   $p10   $p15   $p20"
    p5=$(testPLim $majFile 5e-5)
    p10=$(testPLim $majFile 5e-10)
    p15=$(testPLim $majFile 5e-15)
    p20=$(testPLim $majFile 5e-20)
    echo "Major   $p5   $p10   $p15   $p20"
  done
}

echo "Below are counts of significant SNPs from the alignment methods (expand and major) with the ratio between them."
echo "Phen Expand Major Ratio (repeated for p < (5e-5, 5e-10, 5e-15, 5e-20)"
cd aln_result
testAln $dir
cd ..
echo ""
echo "Below are the length (k) of reported significant k-mers for each phenotype in this test set."
cd kmer_result
python3.5 $testKmer
cd ..

echo ''

# Report number of cases/controls
# cd aln_result
# for file in epigen_major_*.log
# do
#     stub="${file%.*}"
#     phen="${stub/epigen_major_/}"
#     counts=$(grep 'remaining phenotypes' $file)
#     counts="${counts/Among remaining phenotypes, /}"
#     echo "$phen  :  $counts"
# done
# cd ..

echo ''
