#! /usr/bin/env python3.5

import glob
import os

files = glob.glob('important*.aln.fa')
if len(files) == 0 :
    files = glob.glob('alignedKmers/important*.aln.fa')

kmerSizes = [ '3 ', '4 ', '5 ', '6 ', '7 ', '8 ', '9 ', '10', '11', '12', '13', '14', '15', '16', '17', '18', '19', '20' ]

def countHeaders(f) :
    count = 0
    with open(f, 'rt') as ifh :
        for line in ifh :
            if line[0] == '>' :
                count += 1
    return count

def getCount(fname) :
    if os.path.exists(fname) :
        return countHeaders(fname)
    else :
        return 0

def getCountStr(counts) :
    rv = ''
    for c in counts :
        if c < 10 :
            rv = rv + '%d  '%c
        else :
            rv = rv + '%d '%c
    return rv

phens = set()
for file in files :
    if '/' in file :
        file = file.split('/')[1]
    fs = file.split('.')
    phen = fs[1]
    phens.add(phen)

print('Phen           %s' %' '.join(kmerSizes))
for phen in phens :
    counts = []
    for size in kmerSizes :
        size = size.strip()
        fname = 'alignedKmers/important%s.%s.aln.fa' %(size, phen)
        counts.append(getCount(fname))
    while len(phen) < 15 :
        phen = phen + ' '
    countStr = getCountStr(counts)
    print('%s%s' %(phen, countStr))
