#! /usr/bin/env python3.5

indel_penalty = -9999999999999

def score_matrix(a, b) :
    global indel_penalty
    if a == b :
        return 1
    else :
        return indel_penalty

def backup(back, seq1, seq2) :
    res1 = []
    res2 = []
    i = len(seq1)
    j = len(seq2)
    while i > 0 or j > 0 :
        i2, j2 = back[i][j]
        if i2 == i :
            res1.append('-')
        else :
            res1.append(seq1[i2])
        if j2 == j :
            res2.append('-')
        else :
            res2.append(seq2[j2])
        i = i2
        j = j2
    return ''.join(res1[::-1]) , ''.join(res2[::-1])

# Down is free when j == 0 (before beginning of seq2)
# Right is free when i == len(seq1) (after end of seq1)
def update(sm, i, j, seq1, seq2) :
    global indel_penalty
    options = {}
    # Try diagonal
    if i > 0 and j > 0 :
        options[ sm[i-1][j-1] + score_matrix(seq1[i-1], seq2[j-1]) ] = (i-1, j-1)
    # Try down
    if i > 0 :
        # We prefer mismatches to indels for this kind of alignment, I think.
        # So, I don't replace the mismatch if its score already exists.
        sc = sm[i-1][j] + indel_penalty
        if sc not in options :
            options[ sc ] = (i-1, j)
    # Down is free in this case
    if j == 0 :
        sc = sm[i-1][j]
        if sc not in options :
            options[ sc ] = (i-1, j)
    # Try right
    if j > 0 :
        sc = sm[i][j-1] + indel_penalty
        if sc not in options :
            options[ sc ] = (i, j-1)
    # Right is free in this case
    if i == len(seq1) :
        sc = sm[i][j-1]
        if sc not in options :
            options[ sc ] = (i, j-1)
    best_score = max(options)
    return best_score , options[best_score]

def trim(res1, res2) :
    while len(res1) > 0 and res1[-1] == '-' :
        res1 = res1[:-1]
        if len(res2) > 0 :
            res2 = res2[:-1]
    while len(res2) > 0 and res2[0] == '-' :
        if len(res1) > 0 :
            res1 = res1[1:]
        res2 = res2[1:]
    return res1 , res2

def overlap_alignment(seq1, seq2) :
    sm = [[0 for j in range(len(seq2) + 1)] for i in range(len(seq1) + 1)]
    back = [[(0,0) for j in range(len(seq2) + 1)] for i in range(len(seq1) + 1)]
    for i in range(len(seq1)+1) :
        for j in range(len(seq2)+1) :
            if i == 0 and j == 0 :
                sm[i][j] = 0
                continue
            sm[i][j] , back[i][j] = update(sm, i, j, seq1, seq2)
    res1 , res2 = backup(back, seq1, seq2)
    res1 , res2 = trim(res1, res2)
    return res1, res2, sm[len(seq1)][len(seq2)]

def getPerfectOverlap(seq1, seq2) :
    res1, res2, score = overlap_alignment(seq1, seq2)
    if res1 != res2 :
        return ''
    else :
        return res1

if __name__ == '__main__' :
    import sys
    overlap = getPerfectOverlap(sys.argv[1], sys.argv[2])
    print(overlap)
