#! /bin/bash

trap 'exit' INT

if [[ $# -ne 4 ]]
then
    echo 'Must have four arguments: seqFile, phenFile, scriptsDir, summaryOutputFile (which this script creates)'
    exit 1
fi

seqFile=$1
phenFile=$2
scriptsDir=$3
summaryOutputFile=$4

# python3.5 "$scriptsDir/helpers/perfectMatch/localAlnByPhen.py" $phenFile $seqFile
python3.5 "$scriptsDir/helpers/perfectMatch/localAlnByPhen.py" -g $phenFile $seqFile

echo 'phen cases perfectColWidth' > $summaryOutputFile

for file in *.aln.fa
do
  echo $file
  python3.5 "$scriptsDir/helpers/perfectMatch/longestPerfectMatch.py" $file $summaryOutputFile
done

