#! /usr/bin/env python3.5

import os
import subprocess

class Option :
    def __init__(self, _seq, _pos) :
        self.seq = _seq
        self.pos = _pos
    def copy(self) :
        return Option(self.seq, self.pos)

def readFasta(fname) :
    seqs = {}
    ID = ''
    seq = ''
    fh = open(fname, 'rt')
    for line in fh :
        line = line.strip()
        if line[0] == '>' :
            if len(seq) != 0 :
                seqs[ID] = seq
            ID = line[1:].strip()
            seq = ''
        else :
            seq = seq + line.upper()
    if len(seq) != 0 :
        seqs[ID] = seq
    return seqs

def updateCurrent(current, seqMap, ids, i) :
    for j in range(len(ids)) :
        nchar = seqMap[ids[j]][i]
        if j == 0 :
            current.seq = current.seq + nchar
            if len(current.seq) == 1 :
                current.pos = i
        if nchar != current.seq[-1] or nchar == '-' :
            current = Option('', i)
            break
    return current

def longestPerfectMatch(seqMap) :
    possibles = []
    ids = [ id for id in seqMap.keys() ]
    current = Option('', 0)
    for i in range(len(seqMap[ids[0]])) :
        prev = current.copy()
        current = updateCurrent(current, seqMap, ids, i)
        if len(current.seq) == 0 and len(prev.seq) != 0 :
            possibles.append(prev.copy())
    if len(current.seq) != 0 :
        possibles.append(current)
    if len(possibles) == 0 :
        print('None.')
        return []
    possibles = sorted(possibles, key=lambda x: (len(x.seq)))[::-1]
    longest = len(possibles[0].seq)
    return list(filter(lambda x: (len(x.seq) == longest), possibles))

def main(aln, ofname) :
    seqMap = readFasta(aln)
    longest = longestPerfectMatch(seqMap)
    length = 0
    for l in longest :
        print('%s\t%d'%(l.seq, l.pos))
        length = len(l.seq)
    if 'cases' in aln :
        with open(ofname, 'a') as ofh :
            ofh.write('%s %d %d\n' %(aln.split('.')[0], len(seqMap), length))

if __name__ == '__main__' :
    from argparse import ArgumentParser
    parser = ArgumentParser()
    parser.add_argument('aln', help='file with aligned sequences')
    parser.add_argument('summaryOut', help='file to append summary output (cases only)')
    args = parser.parse_args()
    main(args.aln, args.summaryOut)

