#! /bin/bash
#Edited 05/01/2019 by Alan, PLINK_CMD=plink instead of PLINK_CMD=plink19
#Edited 07/17/2019 by Alan, uses edited assocToSummarySeq python script to differentiate between case-enriched and case-depleted nucleotides

trap 'exit' INT

phenFile=$1
fullFasta=$2
alnFasta=$3
scriptsDir=$4
alnMethods="$scriptsDir/aln_methods"
# NOTE: all arguments $5 and above are considered phenotype names and ARE NECESSARY!
phenotypes="${@:5}"

PLINK_CMD=plink

if ! [ -x "$(command -v $PLINK_CMD)" ]; then
  PLINK_CMD=plink
fi
if ! [ -x "$(command -v $PLINK_CMD)" ]; then
  echo 'Sorry, cannot find executable !'
  exit 1
fi

echo "Running with fasta file $fullFasta"
echo "Running with aln file $alnFasta"
echo "Running with phen file $phenFile"
echo "Running with scripts dir $scriptsDir"

python3.5 "$alnMethods/fastaToSnps.py" --m major $alnFasta epigen_major
python3.5 "$alnMethods/makeCovarFile.py" $alnFasta $phenFile epigen_major.phen.cov

python3.5 "$alnMethods/fastaToSnps.py" --m expand $alnFasta epigen_expand
python3.5 "$alnMethods/makeCovarFile.py" $alnFasta $phenFile epigen_expand.phen.cov


# Make plink
if [[ ! -e epigen_major.bed ]]; then
  $PLINK_CMD --file epigen_major --allow-extra-chr --make-bed --out epigen_major
fi
if [[ ! -e epigen_expand.bed ]]; then
  $PLINK_CMD --file epigen_expand --allow-extra-chr --make-bed --out epigen_expand
fi

function runPlink(){
  tag=$1
  for p in $phenotypes
  do
  if [[ ! -e epigen_"$tag"_$p.assoc ]]; then
    $PLINK_CMD \
      --ci 0.95 \
      --noweb \
      --allow-no-sex \
      --allow-extra-chr \
      --bfile epigen_"$tag" \
      --no-parents \
      --pheno epigen_"$tag".phen.cov \
      --pheno-name $p \
      --assoc \
      --out epigen_"$tag"_$p
  fi
  done
}

declare -a anaTypes=("expand" "major")
for t in "${anaTypes[@]}"
do
  runPlink $t
done

python3.5 "$alnMethods/assocToSummarySeq.py" $alnFasta 5e-5 > epigen_allphen.assoc.sigseq.fasta

for file in *assoc
do
  if [[ ! -e $file.jpg ]]; then
    Rscript "$alnMethods/plotManhattan.r" $file
  fi
done

bash "$scriptsDir/helpers/perfectMatch/perfectMatches.sh" $fullFasta $phenFile $scriptsDir "../phenSummary.txt" > perfectColumns.log
