'''
Takes sharpr scores file in fasta-like format (name followed by new line and then sharpr scores list). Outputs the sum of a CRE's sharpr scores.
Usage: python3 sum_sharpr_scores.py <input file> <output file>
'''

import sys
if len(sys.argv) != 3:
	sys.exit(__doc__)

di = {}
names = []
with open(sys.argv[1], 'r') as f:
	for line in f:
		if ">" in line:
			name = line.rstrip('\n').lstrip('>')
		else:
			name = line.rstrip('\n')
		scores = f.readline().rstrip('\n').split('\t')
		total = 0
		counts = 0
		for score in scores:
			if score != 'NA':
				total += float(score)
				counts += 1
		if counts > 0:
			mean = total
		else:
			mean = 0
		di[name] = str(mean)
		names.append(name)

with open(sys.argv[2], 'w') as o:
	for name in names:
		o.write(name + '\t' + di[name] + '\n')

