'''
Performs smoothing of SHARPR values. Takes the average value of each base +/- 5 bases.
Usage: python3 smooth_sharpr_seq.py <input file> <output file>
'''

import sys
if len(sys.argv) != 3:
	sys.exit(__doc__)

di_scores = {}
order = []
with open(sys.argv[1], 'r') as f:
	for line in f:
		if "#" in line:
			continue
		fields = line.rstrip('\n').split('\t')
		name = fields[0]
		scores = fields[1:]
		di_scores[name] = scores
		order.append(name)

di_smooth = {}
for name in order:
	scores = di_scores[name]
	smooth_scores = []
	for i in range(len(scores)):
		if scores[i] == 'NA':
			smooth_scores.append('NA')
			continue
		total = 0
		counts = 0
		for j in range(i-5, i+6): #for base +/- 5, inclusive
			try:
				if j < 0: #if no info, skip
					continue
				if scores[j] == 'NA':
					continue
				total += float(scores[j])
				counts += 1
			except IndexError:
				break
		mean = total/counts
		smooth_scores.append(str(mean))
	di_smooth[name] = smooth_scores

with open(sys.argv[2], 'w') as o:
	for name in order:
		o.write(name + '\t' + '\t'.join(di_smooth[name]) + '\n')

