'''
Takes sorted (-V option) basalNorm values for replicates and converts them to SHARPR normalize file format.
Assumes that tiles are sorted.
SHARPR normalize format is three tab-separated values: element name + tile, log2FC, number of BCs (assume 10 for now)
Creates as many files as needed for the biological replicates supplied.
Usage: python3 organize_sorted_basalNorms_SHARPR_format.py <input file> <output file basename>
'''

import sys
import math

if len(sys.argv) != 3:
	sys.exit(__doc__)

order = []
di = {}
with open(sys.argv[1], 'r') as f:
	for line in f:
		fields = line.rstrip('\n').split('\t')
		cre = fields[0]
		if 'reverse' in cre:
			name = 'reverse' + cre.split('|')[0]
		else:
			name = cre.split('|')[0]
		new_fields = []
		for value in fields[1:]:
			new_fields.append(str(math.log2(float(value))))
		if name in order:
			di[name].append(new_fields)
		else:
			order.append(name)
			di[name] = [new_fields]

num_reps = len(di[order[0]][0])

basename = sys.argv[2]
for rep in range(num_reps):
	with open(basename + str(rep+1), 'w') as o:
		for name in order:
			cre_tiles = di[name]
			for tile_num in range(len(cre_tiles)):
				o.write(name + '|tile_' + str(tile_num) + '\t' + cre_tiles[tile_num][rep] + '\t10\n')

