'''
Gets the average of all Basal sequences at the infer step. Outputs all infers normalized to the Basal average (done per position).
Usage: python3 average_Basal_inferStep.py <input Infer file> <output file>
'''

import sys

if len(sys.argv) != 3:
	sys.exit(__doc__)

order = []
di = {}
basal_totals = []
count = 0
with open(sys.argv[1], 'r') as f:
	for line in f:
		name = line.split('\t')[0]
		fields = line.rstrip('\n').split('\t')[1:]
		if 'Basal' in name:
			if len(basal_totals) == 0:
				for value in fields:
					basal_totals.append(float(value))
			else:
				for i in range(len(fields)):
					basal_totals[i] = basal_totals[i] + float(fields[i])
			count += 1
		di[name] = fields
		order.append(name)

basal_means = []
for value in basal_totals:
	mean = value/count
	basal_means.append(mean)

with open(sys.argv[2], 'w') as o:
	for name in order:
		new_fields = []
		fields = di[name]
		for i in range(len(fields)):
			new_fields.append(str(float(fields[i]) - basal_means[i]))
		o.write(name + '\t' + '\t'.join(new_fields) + '\n')

