'''
Groups together Basal SHARPR seq info together so that mean and stdev can be obtained for all Basals.
Usage: python3 group_basal_sharpr_seqs.py <list of SHARPR seq files with Basals> <output file for list of Basal names> <output file for .fa Basal SHARPR seq scores>
'''

import sys

if len(sys.argv) < 4:
	sys.exit(__doc__)

di = {}
for filename in sys.argv[1:-2]:
	with open(filename, 'r') as f:
		for line in f:
			if "Basal" in line:
				fields = line.rstrip('\n').split('\t')
				name = filename + '_' + fields[0].rstrip('tile|')
				di[name] = '\t'.join(fields[1:])

with open(sys.argv[-2], 'w') as out_list:
	with open(sys.argv[-1], 'w') as out_scores:
		for name in di:
			out_list.write(name + '\n')
			out_scores.write('>element_' + name + '\n')
			out_scores.write(di[name] + '\n')

