#chimay server R 3.5.1

library(ape)
library(ggtree)
library(ggplot2)

#Import phylogenetic tree from dnd file as "tree"
#Import SHARPR sum data for each node as exp
colnames(exp)[1] <- "label"

tree$node.label <- gsub("_anc", "", tree$node.label)
exp$label <- gsub("_anc", "", exp$label)

#Motif annotations
#Import motif annotations as motif_annotations_tree_elements_forTree
colnames(motif_annotations_tree_elements_forTree) <- c("label", "motif")
exp_matched_nodes <- merge(motif_annotations_tree_elements_forTree, exp)
# motifs <- data.frame(motif_annotations_ancRecon_forTree)
# colnames(motifs)[2] <- "motifs"
# motif_nodes <- motifs[match(tree$node.label, motifs$Element),][2]
# motif_tips <- motifs[match(tree$tip.label, motifs$Element),][2]
# motif_tree <- tree
# motif_tree$node.label <- lapply(motif_nodes, as.character)$motifs
# motif_tree$tip.label <- lapply(motif_tips, as.character)$motifs

#Tree with original labels, Width 1400, Height 700
ggtree(tree,branch.length = "none", ) %<+% exp_matched_nodes + 
  geom_tippoint(aes(fill = V2), size = 7, pch=21) + #pch=21 makes the point->circle with fill
  geom_nodepoint(aes(fill = V2), size = 7, pch=21) +
  #geom_treescale(x=20, y=1) + #not really necessary
  #geom_tiplab( hjust = 1.3, angle=90) +
  #geom_nodelab( vjust= -1, nudge_y=0.7, nudge_x=0.04) +
  scale_fill_gradient2(low = "dodgerblue3", mid = "seashell", high = "firebrick3", 
                       midpoint = 318) + #318 is the y-intercept currently
  theme(legend.position="right") +
  labs(fill="SHARPR\nsum") +
  coord_flip() + 
  xlim(c(14, -1.5))

#With tip labels (10x16 landscape ratio)
ggtree(tree,branch.length = "none", ) %<+% exp_matched_nodes + 
  geom_tippoint(aes(fill = V2), size = 7, pch=21) + #pch=21 makes the point->circle with fill
  geom_nodepoint(aes(fill = V2), size = 7, pch=21) +
  #geom_treescale(x=20, y=1) + #not really necessary
  geom_tiplab( hjust = 1.1, angle=90) +
  #geom_nodelab( vjust= -1, nudge_y=0.7, nudge_x=0.04) +
  scale_fill_gradient2(low = "dodgerblue3", mid = "seashell", high = "firebrick3", 
                       midpoint = 318) + #318 is the y-intercept currently
  theme(legend.position="right") +
  labs(fill="SHARPR\nsum") +
  coord_flip() + 
  xlim(c(18, -1.5))

#Vertical tree, Width 1400, Height 700
ggtree(tree,branch.length = "none", ) %<+% exp_matched_nodes + 
  geom_tippoint(aes(fill = exp1), size = 7, pch=21) + #pch=21 makes the point->circle with fill
  #geom_tippoint(aes(fill = exp2, x = x + 0.5), size = 7, pch=21) + #remove line if only ortholog ancestor values are needed
  geom_nodepoint(aes(fill = exp1), size = 7, pch=21) +
  #geom_treescale(x=20, y=1) + #not really necessary
  geom_tiplab(aes(label = motif), hjust = 1.3, angle=90) +
  geom_nodelab(aes(label = motif), vjust= -1, nudge_y=0.7, nudge_x=0.04) +
  scale_fill_gradient2(low = "dodgerblue3", mid = "seashell", high = "firebrick3", 
                       midpoint = 318) + #318 is the y-intercept currently
  theme(legend.position="right") +
  labs(fill="SHARPR\nsum") +
  coord_flip() + 
  xlim(c(14, -3))

#Horizontal tree
ggtree(tree,branch.length = "none") %<+% exp + 
  geom_tippoint(aes(col = exp1), size = 5) + 
  geom_tippoint(aes(col = exp2, x = x + 2.5), size = 5) + #remove line if only ortholog ancestor values are needed
  geom_nodepoint(aes(col = exp1), size = 4) +
  geom_treescale(x=20, y=1) + #not really necessary
  geom_tiplab(offset = 3.5 ) +
  geom_nodelab( vjust= -1) +
  scale_color_gradient2(low = "dodgerblue3", mid = "seashell", high = "firebrick3") +
  theme(legend.position="right") +
  labs(color="SHARPR sum")

#No node label, larger node and tip points (larger circles)
#Vertical tree, Width 1200, Height 696
ggtree(tree,branch.length = "none") %<+% exp + 
  geom_tippoint(aes(fill = exp1), size = 7, pch=21) + #pch=21 makes the point->circle with fill
  geom_tippoint(aes(fill = exp2, x = x + 0.5), size = 7, pch=21) + #remove line if only ortholog ancestor values are needed
  geom_nodepoint(aes(fill = exp1), size = 7, pch=21) +
  #geom_treescale(x=20, y=1) + #not really necessary
  #geom_tiplab(offset = 3.5 ) +
  #geom_nodelab( vjust= -1, nudge_y=0.6, nudge_x=0.035) +
  scale_fill_gradient2(low = "dodgerblue3", mid = "seashell", high = "firebrick3") +
  theme(legend.position="right") +
  labs(fill="SHARPR\nsum") +
  coord_flip() + 
  scale_x_reverse()

#Try to make the full tree including ortholog ancestor reconstruction
full_tree <- read.tree("/bar/adu/LTR18A/cre-seq/lib2_create/figuring_out_lib_design/repeat_VS_prank_recon/makingTree/full_ancestral_reconstruction_tree.dnd")
full_exp <- read.table("/bar/adu/LTR18A/cre-seq/lib2_create/figuring_out_lib_design/repeat_VS_prank_recon/makingTree/full_recon_tree_SHARPR_sums_HepG2", comment.char = "")

ggtree(full_tree,branch.length = "none") %<+% full_exp + geom_tippoint(aes(col = V2), size = 5) + 
  geom_nodepoint(aes(col = V2), size = 4) +
  geom_treescale(x=20, y=1) +
  geom_tiplab(offset = 0.2 ) +
  scale_color_gradient2(low = "dodgerblue3", mid = "seashell", high = "firebrick3") +
  theme(legend.position="right") +
  labs(color="SHARPR sum")

ggtree(full_tree,branch.length = "none") %<+% full_exp + geom_tippoint(aes(col = V2), size = 5) + 
  geom_nodepoint(aes(col = V2), size = 4) +
  geom_treescale(x=20, y=1) +
  geom_tiplab(offset = 0.2 ) +
  scale_color_gradient2(low = "dodgerblue3", mid = "seashell", high = "firebrick3") +
  theme(legend.position="right") +
  labs(color="SHARPR sum") + theme_tree2()

