'''
Sets an element as the reference point for fastaLike alignment file.
Requires input fasta file to be globally aligned (like through multiple sequence alignment).
Usage: python3 set_element_asReference_fastaLike.py <input fasta file> <name of element to be reference> <output file>
'''

import sys

if len(sys.argv) != 4:
	sys.exit(__doc__)

reference = sys.argv[2].replace("\"", "").replace('\'', '')

di = {}
list_names = []
with open(sys.argv[1], 'r') as f:
	for line in f:
		if line.startswith('>'):
			name = line.lstrip('>').rstrip()
			seq = f.readline().rstrip()
			di[name] = seq
			list_names.append(name)

if reference not in di:
	print('reference ' + reference + ' not in input file')
	sys.exit(__doc__)

with open(sys.argv[-1], 'w') as o:
	for name in list_names:
		o.write('>' + name + '\n')
		o.write(di[name] + '\n')
		o.write(di[reference] + '\n')

