#!/usr/bin/env Rscript
#Script to plot a single path using distance and SHARPR sum scores

#Get arguments, stop if number of arguments is not equal to 2
args = commandArgs(trailingOnly=TRUE)
if (length(args) != 2)
{
  stop("Usage: Rscript plot_path_distance_sharprSum.R <input file> <output file>\n")
}

#ggplot and source
library(ggplot2)
source('~/ggplotting_source', encoding = 'UTF-8')

#Load data
input_file <- read.table(args[1], quote="\"", comment.char="",)
out_file <- args[2]

#Define x and y limits for plotting
sharprMin <- 150
sharprMax <- 700
distanceMin <- 0
distanceMax <- 0.28

#Assign column names to input
colnames(input_file)[1] <- 'Element'
colnames(input_file)[2] <- 'Distance'
colnames(input_file)[3] <- 'SHARPRsum'
colnames(input_file)[5] <- 'Motif_change'

#Plot
distance_plot <- ggplot(input_file, aes(x = Distance, y = SHARPRsum))
pdf(file=out_file)
distance_plot + geom_line() + geom_point() + 
  geom_text(label=input_file$Motif_change, na.rm=TRUE, col='red',
            nudge_y=(sharprMax-sharprMin)/40, nudge_x=(distanceMax-distanceMin)/40) +
  ylim(sharprMin, sharprMax) + xlim(distanceMin, distanceMax)
dev.off()

