'''
Gets all instances of motif changes along all possible paths in a given paths directory.
Usage: python3 get_path_motif_change_events.py <paths directory> <output file>
'''

import sys, os

if len(sys.argv) != 3:
	sys.exit(__doc__)

di = {}
list_elements_change = []

paths_dir = sys.argv[1]

path_files = os.listdir(paths_dir)
for path_file in path_files:
	filename = paths_dir.rstrip('/') + '/' + path_file
	with open(filename, 'r') as f:
		first_line = f.readline()
		fields = first_line.rstrip('\n').split('\t')
		prev_element = fields[0]
		prev_sharpr = fields[2]
		prev_motif = fields[3]
		for line in f:
			fields = line.rstrip('\n').split('\t')
			motif_change = fields[-1]
			if motif_change == 'NA': #No motif change, skip
				prev_element = fields[0]
				prev_sharpr = fields[2]
				prev_motif = fields[3]
				continue
			#Motif change between previous and current elements, get info
			curr_element = fields[0]
			curr_sharpr = fields[2]
			curr_motif = fields[3]
			elements_changing = prev_element + ':' + curr_element
			if elements_changing in list_elements_change: #Already know about this particular motif change event
				prev_element = fields[0]
				prev_sharpr = fields[2]
				prev_motif = fields[3]
			else:
				out_fields = [motif_change, prev_element, prev_sharpr, prev_motif, curr_element, curr_sharpr, curr_motif]
				di[elements_changing] = out_fields
				list_elements_change.append(elements_changing)
				prev_element = fields[0]
				prev_sharpr = fields[2]
				prev_motif = fields[3]

with open(sys.argv[-1], 'w') as o:
	for elements_changing in list_elements_change:
		o.write('\t'.join(di[elements_changing]) + '\n')

