'''
Get simple distance from root and SHARPR sums for hg19 element and corresponding ortholog ancestor pairs.
Usage: python3 get_hg19_orthoAnc_pair_simpleDist_sharprSum.py <input sharprSum file> <output file>
'''

import sys

if len(sys.argv) != 3:
	sys.exit(__doc__)

hg19_elements = []
di = {}
with open(sys.argv[1], 'r') as f:
	for line in f:
		fields = line.rstrip('\n').split('\t')
		name = fields[0]
		if "chr" in name:
			if "hg19" in name:
				element = name.rstrip('_hg19').replace('_', ':')
				hg19_elements.append(element)
				di[element] = fields[1:]
			elif ".anc" in name:
				pieces = name.split('-')[1].split('_')
				element = pieces[0] + ':' + pieces[1] + '-' + pieces[2]
				di[element] = fields[1:]

with open(sys.argv[-1], 'w') as o:
	o.write('Element\thg19_dist\thg19_sharpr\torthoAnc_dist\torthoAnc_sharpr\n')
	for element in hg19_elements:
		orthoAnc = element + '.anc'
		if orthoAnc in di:
			line = element + '\t' + '\t'.join(di[element]) + '\t' + '\t'.join(di[orthoAnc])
			o.write(line + '\n')

