'''
Gets all paths from the root to leaves for a given newick (dnd) file.
Usage: python3 get_all_paths_to_leaves.py <input file> <output file>
'''

import sys
from Bio import Phylo

if len(sys.argv) != 3:
	sys.exit(__doc__)

#Read in tree info
tree = Phylo.read(sys.argv[1], 'newick')
#Get the names of all leaves
leaf_info = tree.get_terminals()
all_leaves = [leaf.name for leaf in leaf_info]
#Get the root
root = tree.root.name
#Get each path from the root and write to output
with open(sys.argv[-1], 'w') as o:
	for leaf in all_leaves:
		o.write(root)
		path_data = tree.get_path(leaf)
		for node in path_data:
			o.write('\t' + node.name)
		o.write('\n')

