'''
Adds hg19 elements to the evolutionary tree .dnd file
Usage: python3 add_hg19_toTree.py <input .dnd file> <output file>
'''

import sys

if len(sys.argv) != 3:
	sys.exit(__doc__)

with open(sys.argv[1], 'r') as f:
	for line in f:
		orig_tree = line.rstrip()

#First add to all "(#" cases
first_blocks = orig_tree.split('(#')
first_adds = []
for i in range(len(first_blocks)):
	block = first_blocks[i]
	if ":" not in block: #No distance => no node listed
		first_adds.append('')
		continue
	orthoAnc = block.split('-')[1].split(':')[0].rstrip('.anc')
	hg19_element = orthoAnc.split('_')[0] + '_' + orthoAnc.split('_')[1] + '-' + orthoAnc.split('_')[2] + '_hg19'
	first_adds.append('(' + hg19_element + ':0.05)')
first_tree = ''
for i in range(len(first_blocks)):
	add = first_adds[i]
	block = first_blocks[i]
	if add == '':
		first_tree += block
	else:
		first_tree += '(' + add
		first_tree += '#' + block

#Next add to all ",#" cases
second_blocks = first_tree.split(',#')
second_adds = []
for i in range(len(second_blocks)):
	block = second_blocks[i]
	if i == 0: #First block, don't add anything
		second_adds.append('')
		continue
	orthoAnc = block.split('-')[1].split(':')[0].rstrip('.anc')
	hg19_element = orthoAnc.split('_')[0] + '_' + orthoAnc.split('_')[1] + '-' + orthoAnc.split('_')[2] + '_hg19'
	second_adds.append('(' + hg19_element + ':0.05)')
second_tree = ''
for i in range(len(second_blocks)):
	add = second_adds[i]
	block = second_blocks[i]
	if i == 0: #First block, just add it with no changes
		second_tree += block
	else:
		second_tree += ',' + add
		second_tree += '#' + block

with open(sys.argv[-1], 'w') as o:
	o.write(second_tree)

