'''
Changes underscores that were changed to dashes for SHARPR analysis back to underscores.
Usage: python3 change_sharpr_underscores_back.py <input file> <output file>
'''

import sys
if len(sys.argv) != 3:
	sys.exit(__doc__)

di = {}
order = []
with open(sys.argv[1], 'r') as f:
	for line in f:
		fields = line.rstrip('\n').split('\t')
		cre = fields[0]
		if "-" in cre:
			if "(-)" not in cre:
				if ":" not in cre:
					if "variant" not in cre:
						if "RepBase" in cre: #RepBase_mostFreq
							cre = cre.replace('-', '_')
						elif "v2" in cre: #v2 CREs
							cre = cre.replace('-', '_')
						else: #rest are #number#-chr_start_stop.prank.anc.fas format
							after_first = '_'.join(cre.split('-')[1:])
							cre = cre.split('-')[0] + '-' + after_first
		fields[0] = cre
		di[cre] = fields
		order.append(cre)

with open(sys.argv[2], 'w') as o:
	for cre in order:
		o.write('\t'.join(di[cre]) + '\n')

