'''
Changes underscores in the 2nd column (CRE) to dashes before the "|" symbol. This will remove the input file and replace it with the output file using the same name.
Note: Used to standardize tile number position for SHARPR analysis.
Usage: python3 change_CRE_underscore_to_dash.py <input file>
'''

import sys
if len(sys.argv) != 2:
	sys.exit(__doc__)

di = {}
order = []
with open(sys.argv[1], 'r') as f:
	for line in f:
		fields = line.rstrip('\n').split('\t')
		bc = fields[0]
		cre = fields[1]
		before_tile = cre.split('|')[0]
		after_tile = cre.split('|')[1]
		new_before_tile = before_tile.replace('_', '-')
		new_cre = new_before_tile + '|' + after_tile
		fields[1] = new_cre
		new_line = '\t'.join(fields) + '\n'
		di[bc] = new_line
		order.append(bc)

with open(sys.argv[1], 'w') as o:
	for bc in order:
		line = di[bc]
		o.write(line)

