'''Takes BC counts output from Illumina_de-muliplex-code_LTR18A_TECRE.sh and adds BC count info to BC-CRE info.
Usage: python3 merge_TECRE_sample_BC_counts.py [BC-CRE file containing all BC's] [list of BC count files]'''

import sys

if len(sys.argv) < 3:
	print(__doc__)
	sys.exit(0)

BC_CRE_file = sys.argv[1]
list_BC_counts = sys.argv[2:]

BC_CRE_dict = {}
BC_list = []
with open(BC_CRE_file, 'r') as f:
	for line in f:
		fields = line.rstrip('\n').split()
		BC = fields[0]
		CRE = fields[1]
		BC_list.append(BC)
		BC_CRE_dict[BC] = [CRE]

for BC_count_file in list_BC_counts:
	BC_counts_dict = {}
	with open(BC_count_file, 'r') as f:
		for line in f:
			fields = line.rstrip('\n').split()
			BC = fields[1]
			count = fields[0]
			BC_counts_dict[BC] = count
	for BC in BC_list:
		if BC in BC_counts_dict:
			BC_CRE_dict[BC].append(str(BC_counts_dict[BC]))
		else:
			BC_CRE_dict[BC].append('0')

with open('TECRE_BC_counts_merged', 'w') as f:
	f.write('BC\tCRE')
	for i in range(len(list_BC_counts)):
		f.write('\tRNA' + str(i+1) + '_techRep2')
	f.write('\n')
	for BC in BC_list:
		f.write(BC)
		for i in range(len(BC_CRE_dict[BC])):
			f.write('\t' + BC_CRE_dict[BC][i])
		f.write('\n')
