'''
Takes TECRE_BC_counts_merged and combines BC counts for the same CRE.
Usage: python3 combine_same_CRE_BC_counts.py TECRE_BC_counts_merged <output file>
'''

import sys

if len(sys.argv) != 3:
	sys.exit(__doc__)

di = {}
order = []
with open(sys.argv[1], 'r') as f:
	header = f.readline()
	for line in f:
		fields = line.rstrip('\n').split('\t')
		CRE = fields[1]
		if CRE not in di:
			order.append(CRE)
			di[CRE] = [int(x) for x in fields[2:]]
		else:
			for i in range(len(fields[2:])):
				di[CRE][i] += int(fields[i+2])

with open(sys.argv[2], 'w') as o:
	o.write(header)
	for CRE in order:
		line = CRE + '\t' + CRE
		for i in range(len(di[CRE])):
			line = line + '\t' + str(di[CRE][i])
		o.write(line + '\n')


