'''
Calculates the average value of Basal (indicated in column 1 or 2) and normalizes all values by the Basal average.
Usage: python3 quick_norm_basal.py <input file> <output file>
'''

import sys

if len(sys.argv) != 3:
	sys.exit(__doc__)

order = []
di = {}
basal = []
with open(sys.argv[1], 'r') as f:
	header = f.readline()
	for line in f:
		fields = line.rstrip('\n').split('\t')
		if fields[0] == 'Basal' or fields[1] == 'Basal':
			for i in range(len(fields)-2):
				basal.append(float(fields[i+2]))
			order.append(fields[0])
			di[fields[0]] = fields
		else:
			di[fields[0]] = fields
			order.append(fields[0])

norm = sum(basal)/len(basal)

with open(sys.argv[2], 'w') as o:
	o.write(header)
	for BC in order:
		fields = di[BC]
		for i in range(len(fields)-2):
			fields[i+2] = str(float(fields[i+2])/norm)
		new_line = '\t'.join(fields) + '\n'
		o.write(new_line)

