'''Takes the output of norm_cpm_CRE-seq.py (normalized_cpm_CRE-seq_file) and normalizes RNA sample counts by plasmid DNA counts. 
Outputs a file (normalized_DNA_CRE-seq_file) with BC, CRE, and plasmid DNA normalized BC counts.
Usage: python plasmid_count_normalization.py <input file: normalized_cpm_CRE-seq_file> <column of plasmid DNA counts> <output file>
'''

import sys

if len(sys.argv) != 4:
	sys.exit(__doc__)

pre_norm_file = sys.argv[1]
DNA_col = int(sys.argv[2])

with open(pre_norm_file, 'r') as f:
	with open (sys.argv[3], 'w') as o:
		header = f.readline()
		o.write(header)
		for line in f:
			fields = line.rstrip('\n').split('\t')
			plasmid_count = float(fields[DNA_col - 1])
			norm_counts = [(float(x) / plasmid_count) for x in fields[2:]]
			new_line = fields[0] + '\t' + fields[1] + '\t'
			for count in norm_counts:
				new_line = new_line + str(count) + '\t'
			o.write(new_line.rstrip('\t') + '\n')

