'''
Extracts the BC counts only for the list of expected BCs.
Usage: python3 extract_expected_BC_counts.py <input counts file> <expected BCs file> <output file>
'''

import sys

if len(sys.argv) != 4:
	sys.exit(__doc__)

bc_list = []
with open(sys.argv[2], 'r') as f:
	for line in f:
		bc = line.rstrip('\n')
		bc_list.append(bc)

di = {}
with open(sys.argv[1], 'r') as f:
	for line in f:
		fields = line.strip().split()
		bc = fields[1]
		if bc in bc_list:
			di[bc] = line

with open(sys.argv[3], 'w') as o:
	for bc in bc_list:
		if bc in di:
			o.write(di[bc])

