'''
Converts replicate mean statistic for RNA/DNA ratio to mean log2FC.
Usage: python3 convert_stats_ratio_toLog2FC.py <input file> <output file>
'''

import sys
import math

if len(sys.argv) != 3:
	sys.exit(__doc__)

with open(sys.argv[1], 'r') as f:
	with open(sys.argv[-1], 'w') as o:
		header = f.readline()
		o.write('Name\tlog2FC\n')
		for line in f:
			fields = line.rstrip().split('\t')
			mean = float(fields[2])
			element = fields[1]
			log2fc = math.log2(mean)
			o.write(element + '\t' + str(log2fc) + '\n')

