'''
Converts replicate basal normalized expression to enrichment scores (just a log2 transformation)
Usage: python3 convert_replicate_basalNorm_toEnrichScore.py <input file> <output file>
'''

import sys
import math

if len(sys.argv) != 3:
	sys.exit(__doc__)

with open(sys.argv[1], 'r') as f:
	with open(sys.argv[-1], 'w') as o:
		header = f.readline()
		o.write(header)
		for line in f:
			fields = line.rstrip('\n').split('\t')
			new_fields = fields[:2]
			for i in fields[2:]:
				new_fields.append(str(math.log2(float(i))))
			o.write('\t'.join(new_fields) + '\n')

