'''
Script to get BC/CREs in a specified order. Assumes header is present.
Usage: python3 arrange_BC_CRE_info.py <input file> <list of BCs/CREs in desired order> <output file>
'''

import sys

if len(sys.argv) != 4:
	sys.exit(__doc__)

di = {}
with open(sys.argv[1], 'r') as f:
	header = f.readline()
	for line in f:
		fields = line.rstrip('\n').split('\t')
		bc = fields[0]
		if bc in di:
			print('BC/CREs not all unique')
			sys.exit(__doc__)
		else:
			di[bc] = line

with open(sys.argv[2], 'r') as f:
	with open(sys.argv[3], 'w') as o:
		o.write(header)
		for line in f:
			bc = line.rstrip('\n')
			if bc in di:
				o.write(di[bc])

