'''
Adds BC raw counts together for separate sequencing runs and combines into one output file. Assumes count files are formatted in BC, CRE, replicates counts tab-separated format.
Usage: python3 add_BC_raw_counts.py <list of count files to combine> <output file>
'''

import sys

if len(sys.argv) < 4:
	sys.exit(__doc__)

order = []
di = {}
for filename in sys.argv[1:-1]:
	with open(filename, 'r') as f:
		header = f.readline() # skip header
		for line in f:
			fields = line.rstrip('\n').split('\t')
			BC = fields[0]
			if BC not in di:
				di[BC] = fields[1:]
				order.append(BC)
			else:
				new = di[BC]
				for i in range(len(new) - 1):
					try:
						new[i+1] = str(int(new[i+1]) + int(fields[i+2]))
					except IndexError:
						break
				di[BC] = new

with open(sys.argv[-1], 'w') as o:
	o.write(header)
	for BC in order:
		new_line = BC + '\t' + '\t'.join(di[BC]) + '\n'
		o.write(new_line)

