% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SpaGene.R
\name{plotLR}
\alias{plotLR}
\title{plot one specific ligand-receptor pair}
\usage{
plotLR(
  expr,
  location,
  normalize = T,
  topn = floor(0.2 * dim(location)[1]),
  knn = 8,
  LRpair = c("Ptn", "Ptprz1"),
  pt.size = 2,
  alpha.min = 0.1,
  max.cut = 0.95
)
}
\arguments{
\item{expr}{gene expression matrix, the row is the gene and the column is the spot/cell}

\item{location}{location matrix, the row number of location should match the column number of expr}

\item{normalize}{whether to normalize the data (default: TRUE)}

\item{topn}{the number of spots/cells considered high expression (default: 20 percent of the total spots/cells)}

\item{knn}{the number of nearest neighbours to search (default: 8)}

\item{LRpair}{the ligand-receptor pair for plot}

\item{pt.size}{the point size (default:2)}

\item{alpha.min}{the alpha for the minimum value (default:0.1)}

\item{max.cut}{the maximum cutoff for the LR activity}
}
\value{
a data frame containing the result of each ligand-receptor pair
}
\description{
plot one specific ligand-receptor pair to find the colocalized region
}
