% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SpaGene.R
\name{SpaGene_sparse}
\alias{SpaGene_sparse}
\title{Identify spatially variable genes for extremely sparse data}
\usage{
SpaGene_sparse(
  expr,
  location,
  normalize = TRUE,
  maxN = floor(0.1 * dim(location)[1]),
  minN = 50,
  perm = 500,
  sizefactor = 10000,
  weight = NULL
)
}
\arguments{
\item{expr}{gene expression matrix, the row is the gene and the column is the spot/cell}

\item{location}{location matrix, the row number of location should match the column number of expr}

\item{normalize}{whether to normalize the data (default: TRUE)}

\item{maxN}{the maximum number of spots/cells considered high expression (default: 10 percent of the total spots/cells)}

\item{minN}{the minimum number of spots/cells considered high expression (default: 50. genes with less than 50 cells/spots expressed are excluded)}

\item{perm}{the number of random permutations (default: 500)}

\item{sizefactor}{the size factor for normalization (default:10000)}

\item{weight}{weights assigned to degree. If NULL, equal weight, wi=1, i is the degree, i=0,1,...2*knn; if "linear", wi=0.5+0.5*i/(2*knn); or weight can be a numeric vector of length 2*knn+1 (default:NULL)}
}
\value{
a list containing results of each gene (spagene_res) and normalized gene expression matrix (normexp)
}
\description{
Identify spatial variable genes based on spatial connectness of spots/cells with high expression. For genes with different sparsity level, the function adjusts the neighborhood search region automatically.
}
