% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SpaGene.R
\name{SpaGene_LR}
\alias{SpaGene_LR}
\title{Identify spatially colocalized ligand-receptor pairs}
\usage{
SpaGene_LR(
  expr,
  location,
  normalize = T,
  topn = floor(0.2 * dim(location)[1]),
  knn = 8,
  perm = 500,
  minN = 0,
  sizefactor = 10000,
  LRpair = LRpair
)
}
\arguments{
\item{expr}{gene expression matrix, the row is the gene and the column is the spot/cell}

\item{location}{location matrix, the row number of location should match the column number of expr}

\item{normalize}{whether to normalize the data (default: TRUE)}

\item{topn}{the number of spots/cells considered high expression (default: 20 percent of the total spots/cells)}

\item{knn}{the number of nearest neighbours to search (default: 8)}

\item{perm}{the number of random permutations (default: 500)}

\item{minN}{the minimum number of spots/cells with gene expression. Genes expressed equal to or less than minN spots/cells are excluded (default:0)}

\item{sizefactor}{the size factor for normalization (default:10000)}

\item{LRpair}{ligand-receptor pair}
}
\value{
a data frame containing the result of each ligand-receptor pair
}
\description{
Identify spatially colocalized ligand-receptor pairs
}
