% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SpaGene.R
\name{SpaGene_CT}
\alias{SpaGene_CT}
\title{Identify spatially variable genes within the same cell type}
\usage{
SpaGene_CT(
  expr,
  location,
  CellType,
  normalize = T,
  top = 0.2,
  knn = 8,
  minN = 0,
  perm = 500,
  weight = NULL
)
}
\arguments{
\item{expr}{gene expression matrix, the row is the gene and the column is the spot/cell}

\item{location}{location matrix, the row number of location should match the column number of expr}

\item{CellType}{the cell type, the length should match the column number of locations}

\item{normalize}{whether to normalize the data (default: TRUE)}

\item{top}{the maximum ratio of spots/cells in the same cell type considered high expression (default: 20 percent of the spots/cells within a cell type, 10 is used if top is less than 10)}

\item{knn}{the number of nearest neighbours to search (default: 8)}

\item{minN}{the minimum number of spots/cells  (default: 0. genes with less than or equal to minN cells/spots expressed are excluded)}

\item{perm}{the number of random permutations (default: 500)}

\item{weight}{weights assigned to degree. If NULL, equal weight, wi=1, i is the degree, i=0,1,...2*knn; if "linear", wi=0.5+0.5*i/(2*knn); or weight is a numeric vector of length 2*knn+1 (default:NULL)}
}
\value{
a data frame containing results of each gene in each cell type
}
\description{
Identify spatial variable genes within the same cell type
}
