% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SpaGene.R
\name{SpaGene}
\alias{SpaGene}
\title{Identify spatially variable genes}
\usage{
SpaGene(
  expr,
  location,
  normalize = T,
  topn = floor(0.2 * dim(location)[1]),
  knn = 8,
  perm = 500,
  minN = 0,
  sizefactor = 10000,
  weight = NULL
)
}
\arguments{
\item{expr}{gene expression matrix, the row is the gene and the column is the spot/cell}

\item{location}{location matrix, the row number of location should match the column number of expr}

\item{normalize}{whether to normalize the data (default: TRUE)}

\item{topn}{the ratio of spots/cells considered high expression (default: 20 percent of the total spots/cells)}

\item{knn}{the number of nearest neighbours to search (default: 8)}

\item{perm}{the number of random permutations (default: 500)}

\item{minN}{the minimum number of spots/cells with gene expression. Genes expressed equal to or less than minN spots/cells are excluded (default:0)}

\item{sizefactor}{the size factor for normalization (default:10000)}

\item{weight}{weights assigned to degree. If NULL, equal weight, wi=1, i is the degree, i=0,1,...2*knn; if "linear", wi=0.5+0.5*i/(2*knn); or weight is a numeric vector of length 2*knn+1 (default:NULL)}
}
\value{
a list containing results of each gene (spagene_res) and normalized gene expression matrix (normexp)
}
\description{
Identify spatial variable genes based on spatial connectness of spots with high expression compared to random permutation
}
