# SpaGene
==========
* [Introduction](#introduction)
* [Installation](#installation)
* [Citation](#citation)
* [Tutorial](#tutorial)

<a name="introduction"/>

# Introduction

SpaGene is a R package to find sptially variable genes and colocalized gene pairs from spatial omics data.

<a name="installation"/>

# Installation

```R

library(devtools)
install_github("liuqivandy/SpaGene")
```


<a name="citation"/>

# Citation

 Liu Q, Hsu Chih-Yuan, Shyr Yu. Scalable and model-free detection of spatial patterns and colocalization, Genome Research,2022(doi: 10.1101/gr.276851.122) 
 

<a name="tutoral"/>

# Tutorial
- [Analyze spatial transcriptomics MOB data](https://htmlpreview.github.io/?https://github.com/liuqivandy/SpaGene/blob/master/Tutorial/mob.html)
- [Analyze MERFISH data](https://htmlpreview.github.io/?https://github.com/liuqivandy/SpaGene/blob/master/Tutorial/MERFISH.html)
- [Analyze Slideseq V2 mouse cerebellum data](https://htmlpreview.github.io/?https://github.com/liuqivandy/SpaGene/blob/master/Tutorial/mc_slideseqv2.html)
- [Analyze 10X Visium mouse brain data](https://htmlpreview.github.io/?https://github.com/liuqivandy/SpaGene/blob/master/Tutorial/mbrain_10X.html)
- [Analyze HDST MOB data](https://htmlpreview.github.io/?https://github.com/liuqivandy/SpaGene/blob/master/Tutorial/HDST.html)
- [Analyze spatial transcriptomics Breat Cancer data](https://htmlpreview.github.io/?https://github.com/liuqivandy/SpaGene/blob/master/Tutorial/Breastcancer.html)
- [Analyze Slideseq V2 MOB data](https://htmlpreview.github.io/?https://github.com/liuqivandy/SpaGene/blob/master/Tutorial/mob_slideseqv2.html)
- [Analyze two 10X Visum mouse brain data: anterior and posterior regions](https://htmlpreview.github.io/?https://github.com/liuqivandy/SpaGene/blob/master/Tutorial/mb_anterior_posterior.html)
