#!/bin/bash
# This script takes two related genomes as inputs, aligns them to each other
# and retrieves the regions specific to the first (TARGET) genome, i.e. with
# no alignment candidate in the other (QUERY) genome, in BED format.
# Dependencies: samtools, minimap2, bedtools
# usage: ./exclusive_genome_regions.sh C3_assembly.fa Neff_assembly.fa > C3_specific_regions.bed
# cmdoret, 20220501

TARGET=$1
QUERY=$2

minimap2 -t4 -x asm5 -a $TARGET $QUERY \
  | samtools sort - \
  | samtools view -F4 -O bam \
  | bedtools bamtobed -i -
